﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using UnityEngine.Networking;

public class AssetBundleManager : MonoBehaviour
{
    public string assetURL;

    void Start()
    {
        StartCoroutine(DownloadAssetBundle());
    }

    IEnumerator DownloadAssetBundle()
    {
        UnityWebRequest www = UnityWebRequestAssetBundle.GetAssetBundle(assetURL);
        yield return www.SendWebRequest();

        if (www.isNetworkError || www.isHttpError)
        {
            Debug.Log(www.error);
        }
        else
        {
            AssetBundle bundle = DownloadHandlerAssetBundle.GetContent(www);

            LoadAssets(bundle);
        }
    }

    private void LoadAssets(AssetBundle _bundle)
    {        
        foreach (string n in _bundle.GetAllAssetNames())
        {
            GameObject _g = _bundle.LoadAsset(n) as GameObject;
            print(n + " loaded.");

            Instantiate(_g, new Vector3(0, 0, 0), Quaternion.identity);
        }
    }
}
