﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public class ObjectManager : MonoBehaviour
{
    public List<Mesh> meshes = new List<Mesh>();
    //public string creatorName = "Unknown Creator";
    //public string creationName = "Unknown Creation";
    //public string creationInfo = "No information...";

    //public GameObject creationPrefab;

    private int currentCreationIndex = 0;

    // Start is called before the first frame update
    void Start()
    {
        LoadAllObjects();
        InvokeRepeating("LoadNewObjects", 10f, 10f);
        InvokeRepeating("ShowNext", 3f, 3f);
 
    }

    // Update is called once per frame
    void Update()
    {
        
    }

    public void LoadAllObjects()
    {
        var loaded_meshes = Resources.LoadAll<Mesh>("");
        
        foreach (Mesh m in loaded_meshes)
        {
            Debug.Log(m.name + " added to display list.");
            meshes.Add(m);
        }
    }

    void LoadNewObjects()
    {
        Debug.Log("Attempting to load new creations...");

        var all_meshes = Resources.LoadAll<Mesh>("");

        foreach (Mesh m in all_meshes)
        {
            if (!meshes.Contains(m))
            {
                meshes.Add(m);
                Debug.Log("Added new creation to play list: " + m.name);
            }
            else
            {
                Debug.Log("Didn't load: " + m.name);
            }
        }
    }

    private void ShowNext ()
    {
        if (currentCreationIndex < meshes.Count-1)
        {
            currentCreationIndex++;
        }
        else { currentCreationIndex = 0; }

        GetComponent<MeshFilter>().mesh = meshes[currentCreationIndex];
    }
}
