# Scans nearby BTLE devices (beacons) and plays audio file when in the vicinity of a corresponding, allowed beacon. 
# Based on the bluepy library.
# Phil Gullberg (philippgullberg@gmail.com) 2021 for State Library of Queensland


# import the necessary parts of the bluepy library
from bluepy.btle import Scanner, DefaultDelegate
# additional imports
import pygame # used for the playback of audio
import time, os

pygame.mixer.init() # initialise sound mixer (may take a couple seconds)
scan_duration = 2 # duration of scan
delay = 5 # delay between playing an audio track and starting a new search

# beacons/devices which will be processed after a scan. Beacon MAC-Address, lowercase letters
allowed_beacons =["3c:a3:08:ac:96:c7", "3c:a3:08:ae:07:07", "3c:a3:08:ad:ff:fe", "3c:a3:08:ad:f3:d7"]
# audio files located in the audio folder
beacon_audio_files = ["01-one.mp3", "02-two.mp3", "03-three.mp3", "04-four.mp3"] # Beacon-specific audio files, need to be in same order as allowed_beacons list
misc_audio_files = ["06-not_found.mp3"] # Additional audio files for debugging and misc. purposes

# create a scanner object that sends BLE broadcast packets to the ScanDelegate
scanner = Scanner()#.withDelegate(ScanDelegate())

class BeaconAudioTrigger():
    closest_beacon = None
    num_devices = 0

    # checks whether discovered device is in the list of allowed devices/beacons
    def is_allowed_beacon(self, dev):
        for b in allowed_beacons:
            if b == dev.addr:
                return True
        
        return False

    # Get human readible beacon name as string. Please note that for names under 9 characters the beacon
    # automatically add empty space that will not show up when printed (/x00')
    # Remove special characters by converting to string representation, removing everything after the 
    # backslash and then any non-alphanumerical characters that remain
    def get_beacon_name (self, dev):
        for (adtype, desc, value) in dev.getScanData():
            if desc == 'Complete Local Name':
                return value
    
    def scan (self):
        print("-----------------------------------------------")
        print("scanning...(" + str(scan_duration) + "s)")
        devices = scanner.scan(scan_duration)

        # for each device  in the list of devices
        for dev in devices:
            # Only process allowed beacons/devices
            if not self.is_allowed_beacon(dev):
                continue
            
            # print (dev.addr, dev.addrType, dev.rssi)
            # MAC address, address type, received signal strength
            
            # See if current device/beacon has a stronger signal, if true set as closest beacon
            # Stronger signal strength is interpreted as device being closer (but will not be true in all cases)
            if self.closest_beacon == None:
                self.closest_beacon = dev
                #print("Beacon was none, new closest beacon: " + dev.addr + ": " + str(dev.rssi))
            elif dev.rssi > self.closest_beacon.rssi: 
                self.closest_beacon = dev
                #print("Beacon signal stronger, new closest beacon: " + dev.addr + ": " + str(dev.rssi))
            elif dev.rssi < self.closest_beacon.rssi: 
                pass
                #print("Beacon signal weaker, ignore")
        
        print("closest beacon: " + str(self.closest_beacon.addr))
        print("signal strength: " + str(self.closest_beacon.rssi))
        
 
        self.play(self.closest_beacon)
        
        
    
    def run_next_scan (self):
        self.closest_beacon = None
        print (str(delay) + " seconds until next scan...")
        time.sleep(delay)
        self.scan()

    # Play audio track depending on 
    def play (self, dev):
        if dev == None:
            print ("Did not find any allowed beacons")
            track = misc_audio_files[0]
        else:
            track = allowed_beacons.index(dev.addr)     
  
            pygame.mixer.music.load(os.path.abspath(os.getcwd()) + "/audio/" + beacon_audio_files[track])
            pygame.mixer.music.play()

            print("playing audio: " + str(beacon_audio_files[track]))
            while pygame.mixer.music.get_busy() == True:
                continue           
         
            self.run_next_scan()

audio_player = BeaconAudioTrigger()
audio_player.scan()